//LidHolesSwitchOnPCB.scad;

//All walls are the same height;

//This module defines the holes for 
//the OnOff switch when that switch 
//is mounted on the PCB and just pokes 
//through holes in the wall, 
//but is not secured to it;

include <BATT_Dimensions.scad>

module LidHolesSwitchOnPCB()
{

echo("Begin LidHolesSwitchOnPCB");

//The OnOff hole is in two parts:
//A simple cube for the PCB;
//Another simple cube for the switch itself;

//The switch protrudes through 
//the wall of the lid;
//It does need rebates inside the lid;
//It does not need holes for mounting screws;

//The hole for the PCB;
translate([OnOffHolePcbDeltaX, 
    OnOffHolePcbDeltaY, OnOffHolePcbDeltaZ])
cube([OnOffHolePcbX, 
        OnOffHolePcbY, OnOffHolePcbZ], 
    center=true);

//The hole for the switch;
translate([OnOffHoleSwDeltaX, 
    OnOffHoleSwDeltaY, OnOffHoleSwDeltaZ])
cube([OnOffHoleSwX, 
        OnOffHoleSwY, OnOffHoleSwZ], 
    center=true);

//The left rebate;
translate([OnOffHoleSwDeltaX +OnOffRebateX/2, 
    OnOffRebateDeltaY, OnOffRebateDeltaZ])
cube([OnOffRebateW, 
        OnOffRebateY, OnOffRebateZ], 
    center=true);

//The right rebate;
translate([OnOffHoleSwDeltaX -OnOffRebateX/2, 
    OnOffRebateDeltaY, OnOffRebateDeltaZ])
cube([OnOffRebateW, 
        OnOffRebateY, OnOffRebateZ], 
    center=true);

}
//
